% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadocumentation.R
\docType{data}
\name{dass}
\alias{dass}
\title{Depression Anxiety and Stress Scale}
\format{a dataframe. Columns represent questionnaire items and rows represent individuals}
\usage{
dass
}
\description{
This dataset includes a randomly selected subsample of 
5000 online participants who participated
in a questionnaire available through the Open Source Psychometrics
Project (https://openpsychometrics.org/), an organization that maintains an 
open website for the public to take psychometric tests for 
educational and entertainment purposes
}
\details{
The Depression Anxiety and Stress Scale (DASS) is a self-report
instrument for measuring depression, anxiety, and tension or stress. 
Each of 42 items falls into one of the three corresponding subscales.

Labels for DASS items in this dataset are denoted by the prefix 
"dass" and the suffix "_D", "_A", or "_S", indicating the depression,
anxiety, or stress subscale.

Also includes demographics such as country, education level, 
rearing environment (urban/suburban/rural), gender, 
English as a native language, age, religion, sexual orientation, 
race, voting status, marriage status, and number of children 
in one's family during childhood.

The full dataset is publicly available at https://openpsychometrics.org/_rawdata/DASS_data_21.02.19.zip
and can be cited as:

OpenPsychometrics (2019). Depression Anxiety and Stress Scale Survey. Retrieved from https://openpsychometrics.org/_rawdata/DASS_data_21.02.19.zip
}
\examples{
head(dass)
\donttest{

## Example networktree with DASS
data(dass)
## Select depression subscale
nodeVars <- colnames(dass)[(grep("_D", colnames(dass)))]
splitVars <- c("gender","orientation","race","married","engnat")
myTree<-networktree(dass[,nodeVars], dass[,splitVars])
myTree
plot(myTree)

}

}
\keyword{datasets}
