% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_mask.R
\name{check_mask}
\alias{check_mask}
\title{Check Mask is Binary}
\usage{
check_mask(mask, allow.NA = FALSE, allow.array = TRUE)
}
\arguments{
\item{mask}{Object of class \code{nifti}}

\item{allow.NA}{allow NAs in the mask}

\item{allow.array}{if \code{class(mask)} is \code{"array"}, is this OK?}
}
\value{
Logical indicating if object is binary mask with only 0, 1, and \code{NA}
if applicable
}
\description{
Determine if only values in a mask are 0/1
}
\examples{
arr = array(rbinom(1000, size = 1, prob = 0.2), dim = c(10,10,10))
nim = oro.nifti::nifti(arr)
check_mask(nim)
}
