% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neuroslice.R, R/neurospace.R
\name{index_to_grid}
\alias{index_to_grid}
\alias{index_to_grid,NeuroSlice,numeric-method}
\alias{index_to_grid,NeuroSpace,numeric-method}
\alias{index_to_grid,NeuroVec,index-method}
\alias{index_to_grid,NeuroVec,integer-method}
\alias{index_to_grid,NeuroVol,index-method}
\alias{index_to_grid,NeuroVol,integer-method}
\title{Convert 1d indices to n-dimensional grid coordinates}
\usage{
index_to_grid(x, idx)

\S4method{index_to_grid}{NeuroSlice,numeric}(x, idx)

\S4method{index_to_grid}{NeuroSpace,numeric}(x, idx)

\S4method{index_to_grid}{NeuroVec,index}(x, idx)

\S4method{index_to_grid}{NeuroVec,integer}(x, idx)

\S4method{index_to_grid}{NeuroVol,index}(x, idx)

\S4method{index_to_grid}{NeuroVol,integer}(x, idx)
}
\arguments{
\item{x}{A \code{NeuroSlice} object}

\item{idx}{Integer vector of linear indices to convert}
}
\value{
A numeric \code{matrix} of grid coordinates.
}
\description{
Converts linear indices to 2D grid coordinates for a \code{NeuroSlice} object.
}
\details{
Convert Linear Indices to Grid Coordinates
}
\examples{

 bvol <- NeuroVol(array(0, c(10,10,10)), NeuroSpace(c(10,10,10), c(1,1,1)))
 idx <- 1:10
 g <- index_to_grid(bvol, idx)
 bvol[g]

slice_space <- NeuroSpace(c(10, 10))
slice_data <- matrix(1:100, 10, 10)
slice <- NeuroSlice(slice_data, slice_space)

# Convert single index
coords <- index_to_grid(slice, 55)

# Convert multiple indices
indices <- c(1, 25, 50, 75, 100)
coords_mat <- index_to_grid(slice, indices)

}
\seealso{
\code{\link{grid_to_index}} for the inverse operation
}
