% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_newsmap.R
\name{textmodel_newsmap}
\alias{textmodel_newsmap}
\title{Semi-supervised Bayesian multinomial model for geographical document
classification}
\usage{
textmodel_newsmap(x, y, smooth = 1, verbose = quanteda_options("verbose"))
}
\arguments{
\item{x}{dfm from which features will be extracted}

\item{y}{dfm in which features will be class labels}

\item{smooth}{smoothing parameter for word frequency}

\item{verbose}{if \code{TRUE}, show progress of training}
}
\description{
Train a Newsmap model to predict geographical focus of documents using a
pre-defined seed dictionary. Currently seed dictionaries are available in
English, German and Japanese.
}
\examples{
require(quanteda)
text_en <- c(text1 = "This is an article about Ireland.",
             text2 = "The South Korean prime minister was re-elected.")

toks_en <- tokens(text_en)
label_toks_en <- tokens_lookup(toks_en, data_dictionary_newsmap_en, levels = 3)
label_dfm_en <- dfm(label_toks_en)

feat_dfm_en <- dfm(toks_en, tolower = FALSE)

model_en <- textmodel_newsmap(feat_dfm_en, label_dfm_en)
predict(model_en)


}
\references{
Kohei Watanabe. 2018.
  "\href{http://www.tandfonline.com/eprint/dDeyUTBrhxBSSkHPn5uB/full}{Newsmap:
  semi-supervised approach to geographical news classification.}"
  \emph{Digital Journalism} 6(3): 294-309.
}
