% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/split.R
\docType{methods}
\name{bind}
\alias{bind}
\alias{rbind2,CompositionMatrix,CompositionMatrix-method}
\title{Combine Two Composition Matrices}
\usage{
\S4method{rbind2}{CompositionMatrix,CompositionMatrix}(x, y)
}
\arguments{
\item{x, y}{A \code{\linkS4class{CompositionMatrix}} object.}
}
\value{
A \code{\linkS4class{CompositionMatrix}} objects.
}
\description{
Combine Two Composition Matrices
}
\details{
\code{rbind2()} combine by rows.
}
\examples{
## Create a data.frame
X <- data.frame(
  samples = c("A", "A", "A", "B", "B", "B", "C", "C", "C"),
  groups = c("X", "X", "X", "X", NA, NA, "Y", "Y", "Y"),
  Ca = c(7.72, 7.32, 3.11, 7.19, 7.41, 5, 4.18, 1, 4.51),
  Fe = c(6.12, 5.88, 5.12, 6.18, 6.02, 7.14, 5.25, 5.28, 5.72),
  Na = c(0.97, 1.59, 1.25, 0.86, 0.76, 0.51, 0.75, 0.52, 0.56)
)

## Coerce to a compositional matrix
Y <- as_composition(X)

## Split by group
## /!\ Unassigned samples (NA) are discarded ! /!\
(s1 <- split(Y, f = X$groups))

## Better to use grouped matrix
(s2 <- group_split(Y, by = X$groups))

Z <- as_composition(X, groups = 2)
(s3 <- group_split(Z))

## Bind by rows
do.call(rbind, s3)
}
\seealso{
Other subsetting methods: 
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{subsetting methods}
