% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_ftn_charting.R
\name{load_ftn_charting}
\alias{load_ftn_charting}
\title{Load FTN Charting Data}
\source{
FTNData.com
}
\usage{
load_ftn_charting(
  seasons = most_recent_season(),
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{a numeric vector of seasons to return, defaults to most recent season.
If set to \code{TRUE}, returns all available data. Data available from 2022 onwards.}

\item{file_type}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
Play-level manual charting data from FTN Data
}
\description{
FTN Data manually charts plays and has graciously provided a subset of their
charting data to be published via the nflverse. Data is available from the 2022
season onwards and is charted within 48 hours following each game. This data
is released under the \href{https://creativecommons.org/licenses/by-sa/4.0/}{CC-BY-SA 4.0}
Creative Commons license and attribution must be made to \strong{FTN Data via nflverse}
}
\examples{
\donttest{
  try({ # prevents cran errors
  load_ftn_charting()
  })
}

}
\seealso{
\url{https://www.ftndata.com}

\code{vignette("Data Dictionary - FTN Charting")}

\url{https://nflreadr.nflverse.com/articles/dictionary_ftn_charting.html} for the web data dictionary

Other ftn_charting: 
\code{\link{dictionary_ftn_charting}}
}
\author{
FTN Data
}
\concept{ftn_charting}
