% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proteinpaint_transefer.R
\name{fusions2pp_meta}
\alias{fusions2pp_meta}
\title{Function to convert fusion data to ProteinPaint heatmap meta rows \url{https://pecan.stjude.org/pp} input format.}
\usage{
fusions2pp_meta(input_data, input_type = "fusioncatcher",
  config_file = system.file("extdata", "config/proteinpaint.toml", package =
  "ngstk"), config_list = NULL, hander_confg_file = system.file("extdata",
  "config/hander.toml", package = "ngstk"),
  mhander_confg_file = system.file("extdata", "config/mhander.toml", package =
  "ngstk"), hander_funs = NULL, mhander_funs = NULL,
  hander_extra_params = NULL, mhander_extra_params = NULL, outfn = NULL)
}
\arguments{
\item{input_data}{A gene fusions data.frame need to be converted to ProteinPaint input.}

\item{input_type}{Point the input data format (fusioncatcher or others)}

\item{config_file}{ngstk ProteinPaint configuration file path, default is 
system.file('extdata', 'config/proteinpaint.toml', package = 'ngstk')}

\item{config_list}{ngstk ProteinPaint configuration, default is NULL and 
read from config_file}

\item{hander_confg_file}{ngstk hander configuration file path, default is 
system.file('extdata', 'config/hander.toml', package = 'ngstk')}

\item{mhander_confg_file}{ngstk hander configuration file path, default is 
system.file('extdata', 'config/mhander.toml', package = 'ngstk')}

\item{hander_funs}{hander function for single colnum, 
default is NULL and get value from config_file}

\item{mhander_funs}{hander function for mulitple colnums,
#' default is NULL and get value from config_file}

\item{hander_extra_params}{Extra parameters pass to handler}

\item{mhander_extra_params}{Extra parameters pass to mhandler}

\item{outfn}{Default is NULL and not output the result to file}
}
\value{
A data frame
}
\description{
Function to convert fusion data to ProteinPaint heatmap meta rows \url{https://pecan.stjude.org/pp} input format.
}
\examples{
demo_file <- system.file('extdata', 
'demo/proteinpaint/fusions2pp_fusioncatcher.txt', package = 'ngstk')
input_data <- read.table(demo_file, sep = '\\t', header = TRUE, stringsAsFactors = FALSE)
disease <- 'B-ALL'
sampletype <- 'diagnose'
input_data <- data.frame(input_data, disease, sampletype)
input_data$disease <- as.character(input_data$disease)
hander_data <- fusions2pp_meta(input_data, input_type = 'fusioncatcher')
}
