% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proteinpaint_transefer.R
\name{fusions2pp}
\alias{fusions2pp}
\title{Function to convert fusion data to ProteinPaint format.}
\usage{
fusions2pp(input_data, input_type = "fusioncatcher",
  config_file = system.file("extdata", "config/proteinpaint.toml",
  package = "ngstk"), config_list = NULL,
  handler_confg_file = system.file("extdata", "config/handler.toml",
  package = "ngstk"), mhandler_confg_file = system.file("extdata",
  "config/mhandler.toml", package = "ngstk"), handler_funs = NULL,
  mhandler_funs = NULL, handler_extra_params = NULL,
  mhandler_extra_params = NULL, outfn = NULL)
}
\arguments{
\item{input_data}{A gene fusions data.frame need to be converted to ProteinPaint input.}

\item{input_type}{Point the input data format (fusioncatcher or others)}

\item{config_file}{ngstk ProteinPaint configuration file path, default is 
system.file('extdata', 'config/proteinpaint.toml', package = 'ngstk')}

\item{config_list}{ngstk ProteinPaint configuration, default is NULL and 
read from config_file}

\item{handler_confg_file}{ngstk handler configuration file path, default is 
system.file('extdata', 'config/handler.toml', package = 'ngstk')}

\item{mhandler_confg_file}{ngstk handler configuration file path, default is 
system.file('extdata', 'config/mhandler.toml', package = 'ngstk')}

\item{handler_funs}{handler function for single colnum, 
default is NULL and get value from config_file}

\item{mhandler_funs}{handler function for mulitple colnums,
#' default is NULL and get value from config_file}

\item{handler_extra_params}{Extra parameters pass to handler}

\item{mhandler_extra_params}{Extra parameters pass to mhandler}

\item{outfn}{Default is NULL and not output the result to file}
}
\value{
A data frame
}
\description{
Function to convert fusion data to ProteinPaint format.
}
\examples{
demo_file <- system.file('extdata', 
'demo/proteinpaint/fusions2pp_fusioncatcher.txt', package = 'ngstk')
input_data <- read.table(demo_file, sep = '\\t', header = TRUE, stringsAsFactors = FALSE)
disease <- 'B-ALL'
sampletype <- 'diagnose'
input_data <- data.frame(input_data, disease, sampletype)
input_data$disease <- as.character(input_data$disease)
handler_data <- fusions2pp(input_data, input_type = 'fusioncatcher')
}
