% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesTables}
\alias{nhanesTables}
\title{Returns a list of table names for the specified survey group.}
\usage{
nhanesTables(data_group, year, nchar = 100, details = FALSE,
  namesonly = FALSE, includerdc = FALSE)
}
\arguments{
\item{data_group}{The type of survey (DEMOGRAPHICS, DIETARY, EXAMINATION, LABORATORY, QUESTIONNAIRE).
Abbreviated terms may also be used: (DEMO, DIET, EXAM, LAB, Q).}

\item{year}{The year in yyyy format where 1999 <= yyyy <= 2014.}

\item{nchar}{Truncates the table description to a max length of nchar.}

\item{details}{If TRUE then a more detailed description of the tables is returned.}

\item{namesonly}{If TRUE then only the table names are returned.}

\item{includerdc}{If TRUE then RDC only tables are included in list.}
}
\value{
The names of the tables in the specified survey group.
}
\description{
Enables quick display of all available tables in the survey group.
}
\details{
Data are retrieved via web scraping using html wrappers from package rvest.
It is often useful to display the table names in an NHANES survey. In effect this
is a convenient way to browse the available NHANES tables.
}
\examples{
nhanesTables('EXAM', 2007)
nhanesTables('LAB', 2009, details=TRUE, includerdc=TRUE)
\donttest{nhanesTables('Q', 2005, namesonly=TRUE)}
}

