% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nhdplus.R
\name{discover_nhdplus_id}
\alias{discover_nhdplus_id}
\title{Discover NHDPlus ID}
\usage{
discover_nhdplus_id(point = NULL, nldi_feature = NULL)
}
\arguments{
\item{point}{An sf POINT including crs as created by:
sf::st_sfc(sf::st_point(..,..), crs)}

\item{nldi_feature}{list with names `featureSource` and `featureID` where
`featureSource` is derived from the "source" column of  the response of
discover_nldi_sources() and the `featureSource` is a known identifier
from the specified `featureSource`.}
}
\value{
integer COMID
}
\description{
Multipurpose function to find a COMID of interest.
}
\examples{
point <- sf::st_sfc(sf::st_point(c(-76.87479, 39.48233)), crs = 4326)
discover_nhdplus_id(point)

nldi_nwis <- list(featureSource = "nwissite", featureID = "USGS-08279500")
discover_nhdplus_id(nldi_feature = nldi_nwis)

}
