% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_nhdplus.R
\name{subset_rpu}
\alias{subset_rpu}
\title{Subset by Raster Processing Unit.}
\usage{
subset_rpu(fline, rpu, run_make_standalone = TRUE)
}
\arguments{
\item{fline}{sf data.frame NHD Flowlines with COMID, Pathlength, LENGTHKM, and Hydroseq.
LevelPathI, RPUID, ToNode, FromNode, and ArbolateSu.}

\item{rpu}{character e.g. "01a"}

\item{run_make_standalone}{boolean should the run_make_standalone function be run on result?}
}
\description{
Given flowlines and an rpu_code, performs a network-safe subset such
that the result can be used in downstream processing. Has been tested to work
against the entire NHDPlusV2 domain and satisfies a number of edge cases.
}
\examples{

source(system.file("extdata/sample_data.R", package = "nhdplusTools"))

nhdplus_path(sample_data)

staged_nhdplus <- stage_national_data(output_path = tempdir())

sample_flines <- readRDS(staged_nhdplus$flowline)

subset_rpu(sample_flines, rpu = "07b")
}
