% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nldi.R
\name{get_nldi_characteristics}
\alias{get_nldi_characteristics}
\title{Get Catchment Characteristics}
\usage{
get_nldi_characteristics(nldi_feature, type = "local")
}
\arguments{
\item{nldi_feature}{list with names `featureSource` and `featureID` where
`featureSource` is derived from the "source" column of  the response of
dataRetrieval::get_nldi_sources() and the `featureID` is a known identifier
from the specified `featureSource`.}

\item{type}{character "all", "local", "total", or "divergence_routed".}
}
\value{
data.frame contianing requested characteristics
}
\description{
Retrieves catchment characteristics from the Network Linked Data Index.
Metadata for these characteristics can be found using `discover_nldi_characteristics()`.
}
\examples{
chars <- get_nldi_characteristics(list(featureSource = "nwissite", featureID = "USGS-05429700"))
names(chars)
head(chars$local, 10)
}
