% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vaa.R
\name{get_vaa_names}
\alias{get_vaa_names}
\title{Available NHDPlusV2 Attributes}
\usage{
get_vaa_names(updated_network = FALSE)
}
\arguments{
\item{updated_network}{logical default FALSE. If TRUE, updated network attributes
from E2NHD and National Water Model retrieved from
\href{https://www.sciencebase.gov/catalog/item/60c92503d34e86b9389df1c9}{here.}}
}
\value{
character vector
}
\description{
Find variables available from the NHDPlusV2 attribute data.frame
}
\details{
The VAA data is a aggregate table of information from the NHDPlusV2
elevslope.dbf(s), PlusFlowlineVAA.dbf(s); and NHDFlowlines. All data
originates from the EPA NHDPlus Homepage
\href{https://www.epa.gov/waterdata/get-nhdplus-national-hydrography-dataset-plus-data}{here}.
To see the location of cached data on your machine use
\code{\link{get_vaa_path}}.
To view aggregate data and documentation, see
\href{https://www.hydroshare.org/resource/6092c8a62fac45be97a09bfd0b0bf726/}{here}
}
\examples{
\dontrun{
# This will download the vaa file to the path from get_vaa_path()
get_vaa_names()

#cleanup if desired
unlink(dirname(get_vaa_path()), recursive = TRUE)
}
}
