% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_paths.R
\name{get_sorted}
\alias{get_sorted}
\title{Get Sorted Network}
\usage{
get_sorted(x, split = FALSE, outlets = NULL)
}
\arguments{
\item{x}{data.frame with an identifier and to identifier in the
first and second columns.}

\item{split}{logical if TRUE, the result will be split into
independent networks identified by the id of their outlet. The
outlet id of each independent network is added as a "terminalID"
attribute.}

\item{outlets}{same as id in x; if specified only the network
emanating from these outlets will be considered and returned.}
}
\value{
data.frame containing a topologically sorted version
of the requested network and optionally a terminal id.
}
\description{
given a tree with an id and and toid in the
first and second columns, returns a sorted and potentially
split set of output.

Can also be used as a very fast implementation of upstream
with tributaries navigation. The full network from each
outlet is returned in sorted order.
}
\examples{
source(system.file("extdata/new_hope_data.R", package = "nhdplusTools"))

fpath <- get_tocomid(
  dplyr::select(new_hope_flowline, COMID, FromNode, ToNode, Divergence, FTYPE,
                AreaSqKM, LENGTHKM, GNIS_ID)
)

head(fpath <- get_sorted(fpath, split = TRUE))

fpath['sort_order'] <- 1:nrow(fpath)

plot(fpath['sort_order'])

}
