% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp3xd4YE/filefb25d8e9933
\name{Interval}
\alias{Interval}
\alias{dinterval}
\alias{rinterval}
\title{Interval calculations}
\usage{
dinterval(x, t, c, log = FALSE)

rinterval(n = 1, t, c)
}
\arguments{
\item{x}{vector of interval indices.}\item{t}{vector of values.}\item{c}{vector of one or more values delineating the intervals.}\item{log}{logical; if TRUE, probability density is returned on the log scale.}\item{n}{number of observations.}}\value{
\code{dinterval} gives the density and \code{rinterval} generates random deviates,
but these are unusual as the density is 1 if \code{x} indicates the interval in which \code{t}
falls and 0 otherwise and the deviates are simply the interval(s) in which \code{t} falls.
}
\description{
Calculations to handle censoring
}
\details{
Used for working with censoring in BUGS code.
Taking \code{c} to define the endpoints of two or more intervals (with implicit endpoints of plus/minus infinity), \code{x} (or the return value of \code{rinterval}) gives the non-negative integer valued index of the interval in which \code{t} falls. See the NIMBLE manual for additional details.
}
\examples{
endpoints <- c(-3, 0, 3)
vals <- c(-4, -1, 1, 5)
x <- rinterval(4, vals, endpoints)
dinterval(x, vals, endpoints)
dinterval(c(1, 5, 2, 3), vals, endpoints)
}
\author{
Christopher Paciorek
}
\seealso{
\link{Distributions} for other standard distributions
}

