% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APT_functions.R
\name{buildAPT}
\alias{buildAPT}
\title{Create an APT function, from an MCMCconf object}
\usage{
buildAPT(conf, Temps, monitorTmax = TRUE, ULT = 1e+06, thinPrintTemps = 1, ...)
}
\arguments{
\item{conf}{An object of class MCMCconf that specifies the model, samplers,
monitors, and thinning intervals for the resulting MCMC function.  See
\code{configureMCMC} for details of creating MCMCconf objects.
Alternatively, \code{MCMCconf} may a NIMBLE model object, in which case an
MCMC function corresponding to the default MCMC configuration for this
model is returned.}

\item{Temps}{A numeric vector giving the initial temperature ladder.}

\item{monitorTmax}{A logical indicator (default = TRUE) controlling if MCMC output should be stored at the hottest rung of the temperature ladder. Useful when monitoring the behaviour of APT. When TRUE mvSamples and mvSamples2 monitor T=1 and mvSamplesTmax and mvSamples2Tmax provide identically defined monitors (i.e. for exactly the same nodes) for T=Tmax.}

\item{ULT}{A numeric value (default = 1E6) that provides an upper limit to temperature during APT.}

\item{thinPrintTemps}{A numeric value controlling how often temperatures of the temperature ladder should be printed to screen when runtime parameter printTemps is TRUE. The default value of 1 is often too verbose. A good value to use is niter/10.}

\item{...}{Additional arguments to be passed to \code{configureMCMC} if
\code{conf} is a NIMBLE model object}
}
\value{
Calling \code{buildAPT} returns an uncompiled APT function object. This is very similar to how NIMBLE's \code{buildMCMC} function returns an uncompiled MCMC function object. See \code{?buildMCMC}. Users shold be familiar with the chapter 'MCMC' of the NIMBLE manual.
}
\description{
Adapted from nimble::buildMCMC. Accepts a single required argument, which
may be of class MCMCconf, or inherit from class modelBaseClass (a
NIMBLE model object).  Returns an APT function; see details
section.
}
\details{
Calling buildAPT(conf,Temps,monitorTmax,ULT,thinPrintTemps) will
produce an uncompiled (R) APT function object, say 'myAPT'.

The uncompiled MCMC function will have arguments:

\code{niter} The number of iterations to run the MCMC.

\code{reset} Boolean specifying whether to reset the internal MCMC
sampling algorithms to their initial state (in terms of self-adapting
tuning parameters), and begin recording posterior sample chains anew.
Specifying \code{reset=FALSE} allows the MCMC algorithm to continue running
from where it left off, appending additional posterior samples to the
already existing sample chains. Generally, \code{reset=FALSE} should only
be used when the MCMC has already been run (default = TRUE).

\code{resetMV}: Boolean specifying whether to begin recording posterior sample chains anew. This
argument is only considered when using \code{reset = FALSE}.  Specifying \code{reset = FALSE,
resetMV = TRUE} allows the MCMC algorithm to continue running from where it left off, but
without appending the new posterior samples to the already existing samples, i.e. all previously
obtained samples will be erased. This option can help reduce memory usage during burn-in
(default = FALSE).

\code{resetTempering} Boolean specifying whether to reset the
flexibility of the temperature ladder's adaptation process.

\code{simulateAll} Boolean specifying whether to simulate into all
stochastic nodes.  This will overwrite the current values in all stochastic
nodes (default = FALSE).

\code{time} Boolean specifying whether to record runtimes of the
individual internal MCMC samplers.  When \code{time=TRUE}, a vector of
runtimes (measured in seconds) can be extracted from the MCMC using the
method \code{mcmc$getTimes()} (default = FALSE).

\code{adaptTemps} Boolean specifying whether the temperature
ladder will be adapted or not.

\code{printTemps} Boolean specifying whether the temperature
ladder will be printed during the MCMC. The print frequency is
controlled by thinPrintTemps.

\code{tuneTemper1} Numeric tuning parameter of the adaptation
process of the temperature ladder. See source code for
buildAPT. Defaults to 10.

\code{tuneTemper2} Numeric tuning parameter of the adaptation
process of the temperature ladder. See source code for
buildAPT. Defaults to 1.

\code{progressBar} Boolean specifying whether to display a progress bar
during MCMC execution (default = TRUE).  The progress bar can be
permanently disabled by setting the system option
\code{nimbleOptions(MCMCprogressBar = FALSE)}.

\code{thin} Thinning to be applied to monitor.

\code{thin2} Thinning to be applied to monitor2

Samples corresponding to the \code{monitors} and \code{monitors2} from the
MCMCconf are stored into the interval variables \code{mvSamples} and
\code{mvSamples2}, respectively. These may be accessed and converted into R
matrix objects via: \code{as.matrix(mcmc$mvSamples)}
\code{as.matrix(mcmc$mvSamples2)}

The uncompiled (R) MCMC function may be compiled to a compiled MCMC object,
taking care to compile in the same project as the R model object, using:
\code{Cmcmc <- compileNimble(Rmcmc, project=Rmodel)}

The compiled function will function identically to the uncompiled object,
except acting on the compiled model object.
}
\examples{

## See the nimbleAPT vignette for more details.
bugsCode <- nimbleCode({
  for (ii in 1:nObs) {
    y[ii,1:2] ~ dmnorm(mean=absCentroids[1:2], cholesky=cholCov[1:2,1:2], prec_param=0)
  }
  absCentroids[1:2] <- abs(centroids[1:2])
  for (ii in 1:2) {
    centroids[ii] ~ dnorm(0, sd=1E3)
  }
})

nObs      <- 100
centroids <- rep(-3, 2)
covChol   <- chol(diag(2))

rModel <- nimbleModel(bugsCode,
                      constants=list(nObs=nObs, cholCov=covChol),
                      inits=list(centroids=centroids))
simulate(rModel, "y")
rModel <- nimbleModel(bugsCode,
                      constants=list(nObs=nObs, cholCov=covChol),
                      data=list(y=rModel$y),
                      inits=list(centroids=centroids))

conf <- configureMCMC(rModel, nodes="centroids", monitors="centroids", enableWAIC = TRUE)
conf$removeSamplers()
conf$addSampler("centroids[1]", type="sampler_RW_tempered", control=list(temperPriors=TRUE))
conf$addSampler("centroids[2]", type="sampler_RW_tempered", control=list(temperPriors=TRUE))
aptR <- buildAPT(conf, Temps=1:5, ULT= 1000, print=TRUE)




}
\author{
David Pleydell, Daniel Turek
}
