% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMidPointNodes.R
\name{getMidPointNodes}
\alias{getMidPointNodes}
\title{Generate midpoint integration nodes}
\usage{
getMidPointNodes(lowerCoords, upperCoords, numSubintervals = 10)
}
\arguments{
\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of a set of windows. One row for each window.}

\item{numSubintervals}{Number of subintervals each dimension of a window is divided into.}
}
\value{
A list of midpoint nodes and weights.
}
\description{
Generate midpoint nodes and weights for integrating a function numerically over a set of windows. 
For each window, generate a set of equally spaced nodes and weights.
}
\examples{
lowerCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)
getMidPointNodes(lowerCoords, upperCoords, 5)

}
\author{
Wei Zhang
}
