% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is_natomic}
\alias{is_natomic}
\alias{is.natomic}
\alias{is.nlist}
\alias{is.nlists}
\title{Is natomic, nlist or nlists}
\usage{
is.natomic(x)

is.nlist(x)

is.nlists(x)
}
\arguments{
\item{x}{The object to test.}
}
\value{
A flag indicating whether x is a natomic object (is atomic and numeric) or inherits from nlist or nlists.
}
\description{
Test whether x is a \code{\link[=natomic_object]{natomic_object()}},
\code{\link[=nlist_object]{nlist_object()}} or \code{\link[=nlists_object]{nlists_object()}}.
}
\section{Functions}{
\itemize{
\item \code{is.natomic}: Is natomic

\item \code{is.nlist}: Is nlist

\item \code{is.nlists}: Is nlists
}}

\examples{
# is.natomic
is.natomic(list(x = 1))
is.natomic(1)

# is.nlist
is.nlist(1)
is.nlist(list(x = 1))
is.nlist(nlist(x = 1))

# is.nlists
is.nlists(nlist(x = 1))
is.nlists(nlists(nlist(x = 2), nlist(x = 3.5)))
}
