% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmixrGrad.R
\name{nlmixrGill83}
\alias{nlmixrGill83}
\title{Get the optimal forward difference interval by Gill83 method}
\usage{
nlmixrGill83(
  what,
  args,
  envir = parent.frame(),
  which,
  gillRtol = sqrt(.Machine$double.eps),
  gillK = 10L,
  gillStep = 2,
  gillFtol = 0
)
}
\arguments{
\item{what}{either a function or a non-empty character string naming the
    function to be called.}

\item{args}{a \emph{list} of arguments to the function call.  The
    \code{names} attribute of \code{args} gives the argument names.}

\item{envir}{an environment within which to evaluate the call.  This
    will be most useful if \code{what} is a character string and
    the arguments are symbols or quoted expressions.}

\item{which}{Which parameters to calculate the forward difference
and optimal forward difference interval}

\item{gillRtol}{The relative tolerance used for Gill 1983
determination of optimal step size.}

\item{gillK}{The total number of possible steps to determine the
optimal forward/central difference step size per parameter (by
the Gill 1983 method).  If 0, no optimal step size is
determined.  Otherwise this is the optimal step size
determined.}

\item{gillStep}{When looking for the optimal forward difference
step size, this is This is the step size to increase the
initial estimate by.  So each iteration the new step size =
(prior step size)*gillStep}

\item{gillFtol}{The gillFtol is the gradient error tolerance that
is accepable before issuing a warning/error about the gradient estimates.}
}
\value{
A data frame with the following columns:
\itemize{
\item{info}{Gradient evaluation/forward difference information}
\item{hf}{Forward difference final estimate}
\item{df}{Derivative estimate}
\item{df2}{2nd Derivative Estimate}
\item{err}{Error of the final estimate derivative}
\item{aEps}{Absolute difference for forward numerical differences}
\item{rEps}{Relative Difference for backward numerical differences}
\item{aEpsC}{Absolute difference for central numerical differences}
\item{rEpsC}{Relative difference for central numerical differences}
}

The \code{info} returns one of the following:
\itemize{
\item{Not Assessed}{Gradient wasn't assessed}
\item{Good}{Success in Estimating optimal forward difference interval}
\item{High Grad Error}{Large error; Derivative estimate error \code{fTol} or more of the derivative}
\item{Constant Grad}{Function constant or nearly constant for this parameter}
\item{Odd/Linear Grad}{Function odd or nearly linear, df = K, df2 ~ 0}
\item{Grad changes quickly}{df2 increases rapidly as h decreases}
}
}
\description{
Get the optimal forward difference interval by Gill83 method
}
\examples{

## These are taken from the numDeriv::grad examples to show how
## simple gradients are assessed with nlmixrGill83

nlmixrGill83(sin, pi)

nlmixrGill83(sin, (0:10)*2*pi/10)

func0 <- function(x){ sum(sin(x))  }
nlmixrGill83(func0 , (0:10)*2*pi/10)

func1 <- function(x){ sin(10*x) - exp(-x) }
curve(func1,from=0,to=5)

x <- 2.04
numd1 <- nlmixrGill83(func1, x)
exact <- 10*cos(10*x) + exp(-x)
c(numd1$df, exact, (numd1$df - exact)/exact)

x <- c(1:10)
numd1 <- nlmixrGill83(func1, x)
exact <- 10*cos(10*x) + exp(-x)
cbind(numd1=numd1$df, exact, err=(numd1$df - exact)/exact)

sc2.f <- function(x){
  n <- length(x)
   sum((1:n) * (exp(x) - x)) / n
}

sc2.g <- function(x){
  n <- length(x)
  (1:n) * (exp(x) - 1) / n
}

x0 <- rnorm(100)
exact <- sc2.g(x0)

g <- nlmixrGill83(sc2.f, x0)

max(abs(exact - g$df)/(1 + abs(exact)))

}
\author{
Matthew Fidler
}
