% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agq.R
\name{.agq}
\alias{.agq}
\title{Get the adaptive Gauss-Hermite quadrature points and weights}
\usage{
.agq(neta = 2, nAGQ = 3)
}
\arguments{
\item{neta}{number of eta parameters in the model}

\item{nAGQ}{number of adaptive quadrature points to use}
}
\value{
A list with the following elements:
\item{x}{A matrix of quadrature points, one row per point.}
\item{w}{A matrix of quadrature weights, one row per point.}
\item{n}{The number of quadrature points.}
\item{neta}{The number of eta parameters.}
\item{nAQD}{The number of adaptive quadrature points.}
\item{first}{A logical indicating if the first point is zero.}
}
\description{
Get the adaptive Gauss-Hermite quadrature points and weights
}
\examples{
.agq(neta=2, nAGQ=3)
}
\author{
Matthew L. Fidler
}
\keyword{internal}
