% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computingutil.R
\name{normalizedData}
\alias{normalizedData}
\title{Function to return data of normalized covariates}
\usage{
normalizedData(data, covarsVec, replace = TRUE)
}
\arguments{
\item{data}{a dataframe with covariates to normalize}

\item{covarsVec}{a list of covariate names (parameters) that need to be estimates}

\item{replace}{replace the original covariate data with normalized data for easier updated model.}
}
\value{
data frame with all normalized covariates
}
\description{
Function to return data of normalized covariates
}
\examples{

\donttest{
d <- nlmixr2data::theo_sd
d$SEX <-0
d$SEX[d$ID<=6] <-1

covarsVec <- c("WT")


# Normalized covariate (replaced)
df1 <- normalizedData(d,covarsVec,replace=TRUE)

# Normalized covariate (without replacement)
df2 <- normalizedData(d,covarsVec,replace=FALSE)
}
}
\author{
Vishal Sarsani
}
