\name{nl.robcorrts}
\alias{nl.robcorrts}
\alias{dfr.robcorrts}
\title{
 Robust two stage estimate
 }
\description{
 Robust Two stage estimate for nonlinear regreession model with autocorrelated error.
 \code{dfr.robcorrts} is derivative free version.
}
\usage{
nl.robcorrts(formula, data, start = getInitial(formula, data), 
control = nlr.control(tolerance = 0.001, minlanda = 1/2^10, 
maxiter = 25 * length(start)), correlation =  list(StructName = "NAN",
manualcorr = NULL), robfunc, ...)
}
\arguments{
  \item{formula}{
    nl.form object of the nonlinear function model. See \code{\link{nl.form}} object.
  }
  \item{data}{
    list of data with the response and predictor as name of variable.
  }
  \item{start}{
    list of starting value parameter, name of parameters must be represented as names of variable in the list.
  }
  \item{control}{
    nlr.control object, include tolerance, maxiter,... see \code{\link{nlr.control}}.
  }
  \item{correlation}{
      correlation structure, at the moment parameter of AR(p) process.
}
  \item{robfunc}{
    \code{\link{nl.form}} object of robust function.
  }
  \item{\dots}{
    any other argument pass to \code{formula} or \code{robfunc}.
}
}
\details{
    In first stage nonlinear regression parameter estimate by robust MM method, and in second stage autocorrelation structure estimate and finally the generalized MM-estimates the function model parameters.
}
\value{  t2st <- nlmest.NLM(formula, data=data, start=st,robfunc=robfunc,vm=vmat,rm=rmat,control=control,...)
	result <- list(fited=t2st,tm=tm)
  \item{fited}{\code{\link{nl.fitt.rgn}} object generated by \code{\link{nlmest.NLM}} function.}
  \item{tm}{ fitted time series model for residuals.}
}
\references{
Riazoshams, H., Midi, H., Sharipov, O. S.H, (2010). The Performance of Robust Two Stage Estimator in Nonlinear Regression with autocorrelated Error, Communications in Statistics - Simulation and Computation, 39: 1251-1268.
}
\author{
  Hossein Riazoshams, Jul 2009.
  Email: \email{riazihosein@gmail.com}
  URL \url{http://www.riazoshams.com/nlr/}
}
\note{
  This function currently run with AR process. The classic estimate is don by \code{\link{nl.corrts}} function.
  This function call from \code{\link{nlr}}, due to compatibility it is more efficient to call \code{\link{nlr}} by user rather than this function explicitly. 
}
\seealso{
  \code{\link{nl.corrts}}, \code{\link{nlmest.NLM}}, \code{\link{nl.robcorrts}}, \code{\link{nlsqr.gn}}, \code{\link{nl.fitt.gn}}, \code{\link{nlr.control}}
}
\examples{
xr = trade.ir[, 1]
yr = trade.ir[, 2]
a1 <-  nl.robcorrts( nlrobj5[[18]],data=list(xr = xr, yr = yr),
correlation=list(StructName="corAR1"),
robfunc = nl.robfuncs[["hampel"]])
a1$parameters 
}

\keyword{autocorrelated erro}
\keyword{two stage estimate}
\keyword{robust two stage estimate}
