% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdesign_helper.R
\name{simdesign_lhs}
\alias{simdesign_lhs}
\title{Add a latin-hypercube simdesign to a nl object}
\usage{
simdesign_lhs(nl, samples, nseeds, precision)
}
\arguments{
\item{nl}{nl object with a defined experiment}

\item{samples}{number of samples for the latin hypercube}

\item{nseeds}{number of seeds for this simulation design}

\item{precision}{number of digits for the decimal fraction of parameter values}
}
\value{
simdesign S4 class object
}
\description{
Add a latin-hypercube simdesign to a nl object
}
\details{
This function creates a simdesign S4 class which can be added to a nl object.

Variables in the experiment variable list need to provide a numeric distribution with min, max and qfun (e.g. list(min=1, max=4, qfun="qunif")).

The latin hypercube simdesign creates a parameter matrix based on these defined distributions.
Finally, the function reports a simdesign object.
}
\examples{

# To attach a simdesign, a nl object needs to be created first (see ?nl).
# For this example, we load a nl object from test data.

nl <- nl_lhs
nl@simdesign <- simdesign_lhs(nl=nl,
                               samples=100,
                               nseeds=3,
                               precision=3)

}
