% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_connect.R
\name{st_connect}
\alias{st_connect}
\title{Create lines between features of two layers}
\usage{
st_connect(x, y, ids = st_nn(x, y, ...), ...)
}
\arguments{
\item{x}{Object of class \code{sf} or \code{sfc}}

\item{y}{Object of class \code{sf} or \code{sfc}}

\item{ids}{A sparse list representation of features to connect, such as returned by function \code{\link{st_nn}}}

\item{...}{Other arguments passed to \code{st_nn} such as \code{k} and \code{maxdist}}
}
\value{
Object of class \code{sfc} with geometry type \code{LINESTRING}
}
\description{
Create lines between features of two layers
}
\examples{
# Nearest 'city' per 'town'
l = st_connect(towns, cities)
plot(st_geometry(towns), col = "darkgrey")
plot(st_geometry(l), add = TRUE)
plot(st_geometry(cities), col = "red", add = TRUE)

# Ten nearest 'towns' per 'city'
l = st_connect(cities, towns, k = 10)
plot(st_geometry(towns), col = "darkgrey")
plot(st_geometry(l), add = TRUE)
plot(st_geometry(cities), col = "red", add = TRUE)

# Nearest 'city' per 'town', search radius of 50 km
cities = st_transform(cities, 32636)
towns = st_transform(towns, 32636)
l = st_connect(towns, cities, maxdist = 30000)
plot(st_geometry(towns), col = "darkgrey")
plot(st_geometry(l), add = TRUE)
plot(st_buffer(st_geometry(cities), units::set_units(30, km)), border = "red", add = TRUE)
}
