% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vavra_test.R
\name{vavra.test}
\alias{vavra.test}
\title{The Psaradakis and  Vavra test for normality}
\usage{
vavra.test(y,reps = 1000,h = 100,seed = NULL)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{reps}{an integer with the total bootstrap repetitions.}

\item{h}{an integer with the first \code{burn-in} sieve bootstrap replicates.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}
}
\value{
a h.test class with the main results of the Epps hypothesis test. The
h.test class have the following values:
\itemize{
 \item{"bootstrap A"}{The sieve bootstrap A statistic}
 \item{"p.value"}{The p value}
 \item{"alternative"}{The alternative hypothesis}
 \item{"method"}{The used method}
 \item{"data.name"}{The data name.}
}
}
\description{
Performs the Psaradakis and Vavra distance test for normality. The null hypothesis (H0),
is that the given data follows a Gaussian process.
}
\details{
The Psaradakis and Vavra test approximates the empirical distribution
function of the Anderson Darling's statistic, using a sieve bootstrap
approximation. The test was proposed by \emph{Psaradakis, Z. & Vavra, M (20.17)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
vavra.test(y)

}
\references{
Psaradakis, Z. & Vavra, M. (2017). A distance test of normality for a wide class
of stationary process. \emph{Journal of Econometrics and Statistics}. 2, 50-60.

Bulmann, P. (1997). Sieve Bootstrap for time series. \emph{Bernoulli}.
3(2), 123 -148.
}
\seealso{
\code{\link{lobato.test}},\code{\link{epps.test}}
}
\author{
Asael Alonzo Matamoros.
}
