% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hue_flashlights.R
\name{hue_flashlights}
\alias{hue_flashlights}
\title{Flash all the lights connected to your hub}
\usage{
hue_flashlights(bridge_ip = NULL, username = NULL, light_info = NULL,
  flashes = 3)
}
\arguments{
\item{bridge_ip}{Internal IP address of your hue bridge}

\item{username}{Username for connecting to hue bridge}

\item{light_info}{Optional, must be output of get_light_info - if included the function will turn the lights red. The table tells it what state to then reset the lights to.}

\item{flashes}{Number of times to flash the lights on and off}
}
\description{
This function will flash the lights off and on a specified number of times. Currently,
it will effect all lights connected to the hub. If light_info is provided, it will also
turn all the lights red before flashing the lights, then it will reset the lights back to
their previous state afterwards.
}
\section{Bugs}{

Code repo: \url{https://github.com/epijim/notifyme}
}
\examples{
\dontrun{hue_flashlights(bridge_ip,username)}
}
\keyword{Hue}
\keyword{R}
\keyword{notify}

