% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{novelforest_data}
\alias{novelforest_data}
\title{Novel Forest Dataset}
\format{
A \code{data.frame} containing the following response variables:
\describe{
\item{SD_N_0}{first-order native taxonomic diversity, i.e., species richness}
\item{SD_N_2}{second-order native taxonomic diversity, i.e., inverse Simpson index}
\item{SD_E_0}{first-order exotic taxonomic diversity}
\item{SD_E_2}{second-order exotic taxonomic diversity}
\item{FD_N_0}{first-order native functional diversity}
\item{FD_N_2}{second-order native functional diversity}
\item{FD_E_0}{first-order exotic functional diversity}
\item{FD_E_2}{second-order exotic functional diversity,}
}
and the following explanatory variables (and measurement units if you backtransform
them using \code{backtransform}):
\describe{
\item{dist}{Distance to old-growth forests (m)}
\item{size}{Patch area (km^2)}
\item{nitrogen}{Total soil nitrogen (mg/kg)}
\item{phosphorous}{Total extractable soil phosphorous (mg/kg)}
\item{potassium}{Total extractable soil potassium (mg/kg)}
\item{patch}{Forest patch ID}
}

Note that all explanatory variables were log-transformed and standardised to zero mean and
unit standard deviations. Use \code{backtransform} to obtain the variables in
their original scales. See Lai et al. (2021) for more details on model building and
data collection.
}
\usage{
novelforest_data
}
\description{
The dataset used in Lai et al. (2021), who examined the diversity--environment
relationships of native and exotic species in two types of post-cultivation novel secondary
forests in Singapore.
}
\examples{
# To access the dataset
head(novelforest_data)

}
\references{
Lai, H.R., Tan, G.S.Y., Neo, L., Kee, C.Y., Yee, A.T.K., Tan, H.T.W.
and Chong, K.Y. (2021) Decoupled responses of native and exotic tree
diversities to distance from old-growth forest and soil phosphorous in
novel secondary forests. \emph{Applied Vegetation Science}, 24, e12548.
\doi{10.1111/avsc.12548}
}
\seealso{
backtransform
}
\keyword{datasets}
