% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeDuplicates.R
\name{removeDuplicates}
\alias{removeDuplicates}
\title{Remove duplicate records from pedigree}
\usage{
removeDuplicates(ped, reportErrors = FALSE)
}
\arguments{
\item{ped}{dataframe that is the `Pedigree`. It contains pedigree
information. The \code{id} column is required.}

\item{reportErrors}{logical value if TRUE will scan the entire file and
make a list of all errors found. The errors will be returned in a
list of list where each sublist is a type of error found.}
}
\value{
Pedigree object with all duplicates removed.
}
\description{
Part of Pedigree Curation
}
\details{
Returns an updated dataframe with duplicate rows removed.

Returns an error if the table has duplicate IDs with differing data.
}
\examples{
\donttest{
ped <- nprcgenekeepr::smallPed
newPed <- cbind(ped, recordStatus = rep("original", nrow(ped)))
ped1 <- removeDuplicates(newPed)
nrow(newPed)
nrow(ped1)
pedWithDups <- rbind(newPed, newPed[1:3, ])
ped2 <- removeDuplicates(pedWithDups)
nrow(pedWithDups)
nrow(ped2)
}

}
