% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkRequiredCols.R
\name{checkRequiredCols}
\alias{checkRequiredCols}
\title{Examines column names, \code{cols} for required column names}
\usage{
checkRequiredCols(cols, reportErrors)
}
\arguments{
\item{cols}{character vector of column names}

\item{reportErrors}{logical value when \code{TRUE} and missing columns are
found
the \code{errorLst} object is updated with the names of the missing
columns and returned and when \code{FALSE} and missing columns are found
the program is stopped.}
}
\value{
NULL is returned if all required columns are present. See description
of \code{reportErrors} for return values when required columns are missing.
}
\description{
Examines column names, \code{cols} for required column names
}
\examples{
\donttest{
library(nprcgenekeepr)
requiredCols <- getRequiredCols()
cols <-
  paste0("id,sire,siretype,dam,damtype,sex,numberofparentsknown,birth,",
         "arrivalatcenter,death,departure,status,ancestry,fromcenter?,",
         "origin")
all(requiredCols \%in\% checkRequiredCols(cols, reportErrors = TRUE))
}

}
