% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nproc.R
\name{nproc}
\alias{nproc}
\title{Calculate the Neyman-Pearson Receiver Operating Characteristics}
\usage{
nproc(x = NULL, y, method = c("logistic", "penlog", "svm",
  "randomforest", "lda", "nb", "nnb", "ada", "tree"), delta = 0.05,
  split = 1, split.ratio = 0.5, n.cores = 1, randSeed = 0, ...)
}
\arguments{
\item{x}{n * p observation matrix. n observations, p covariates.}

\item{y}{n 0/1 observatons.}

\item{method}{base classification method(s).
\itemize{
\item logistic: Logistic regression. \link{glm} function with family = 'binomial'
\item penlog: Penalized logistic regression with LASSO penalty. \code{\link[glmnet]{glmnet}} in \code{glmnet} package
\item svm: Support Vector Machines. \code{\link[e1071]{svm}} in \code{e1071} package
\item randomforest: Random Forest. \code{\link[randomForest]{randomForest}} in \code{randomForest} package
\item Linear Discriminant Analysis. lda: \code{\link[MASS]{lda}} in \code{MASS} package
\item nb: Naive Bayes. \code{\link[e1071]{naiveBayes}} in \code{e1071} package
\item nnb: Nonparametric Naive Bayes. \code{\link[naivebayes]{naive_bayes}} in \code{naivebayes} package
\item ada: Ada-Boost. \code{\link[ada]{ada}} in \code{ada} package
}}

\item{delta}{the violation rate of the type I error. Default = 0.05.}

\item{split}{the number of splits for the class 0 sample. Default = 1. For ensemble
version, choose split > 1.}

\item{split.ratio}{the ratio of splits used for the class 0 sample to train the
classifier. Default = 0.5.}

\item{n.cores}{number of cores used for parallel computing. Default = 1.}

\item{randSeed}{the random seed used in the algorithm.}

\item{...}{additional arguments.}
}
\value{
An object with S3 class nproc.
\item{typeI.u}{sequence of upper bound of type I error.}
\item{typeII.l}{sequence of lower bound of type II error.}
\item{typeII.u}{sequence of upper bound of type II error.}
\item{auc.l}{the auc value of the lower NP-ROC curve.}
\item{auc.u}{the auc value of the upper NP-ROC curve.}
\item{method}{the base classification method implemented.}
\item{delta}{the violation rate.}
}
\description{
\code{nproc} calculates the Neyman-Pearson Receiver Operating Characteristics
band for a given sequence of type I error values.
}
\examples{
n = 200
x = matrix(rnorm(n*2),n,2)
c = 1 - 3*x[,1]
y = rbinom(n,1,1/(1+exp(-c)))
#fit = nproc(x, y, method = 'svm')
fit2 = nproc(x, y, method = 'penlog')
##Plot the nproc curve
plot(fit2)

\dontrun{
fit3 = nproc(x, y, method = 'penlog',  n.cores = 2)
#In practice, replace 2 by the number of cores available 'detectCores()'
fit4 = nproc(x, y, method = 'penlog', n.cores = detectCores())

#Confidence nproc curves
fit6 = nproc(x, y, method = 'lda')
plot(fit6)
nproc ensembled version
fit7 = nproc(x, y, method = 'lda', split = 11)
plot(fit7)
}

}
\references{
Xin Tong, Yang Feng, and Jingyi Jessica Li (2018), Neyman-Pearson (NP) classification algorithms and NP receiver operating characteristic (NP-ROC), \emph{Science Advances}, \bold{4}, 2, eaao1659.
}
\seealso{
\code{\link{npc}}
}
