% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_arm.R
\name{create_arm_lachin}
\alias{create_arm_lachin}
\title{Create a 'lachin' object}
\usage{
create_arm_lachin(size, accr_time, accr_dist = "pieceuni",
  accr_param = NA, surv_median = NA, surv_exphazard = NA,
  surv_milestone = NA, loss_median = NA, loss_exphazard = NA,
  loss_milestone = NA, follow_time = Inf, total_time = Inf)
}
\arguments{
\item{size}{sample size. If total sample size is unknown, provide
the integer sample size relative to the opposing arm, e.g. 1 for
1:2 randomization ratio or 2 for 2:3.}

\item{accr_time}{accrual duration.}

\item{accr_dist}{accrual distribution. Default is uniform (piecewise uniform
with one interval). Alternatively, 'truncexp' allows for a truncated
exponential distribution as proposed by Lachin and Foulkes (1986).
Depending on the value of \code{accr_param}, this distribution can be
either convex or concave.}

\item{accr_param}{additional accrual parameter for \code{accr_dist}='truncexp'.
\code{accr_param}>0 specifies a convex distribution and \code{accr_param}<0
specifies a concave distribution.}

\item{surv_median}{median survival.}

\item{surv_exphazard}{exponential hazard rate for the survival distribution.}

\item{surv_milestone}{a tuple c(milestone, probability) that uniquely defines the
exponential survival distribution, e.g. c(12, 0.8) corresponds to the exponential
distribution with 80\% survival rate at 12 months.}

\item{loss_median}{median loss to follow-up.}

\item{loss_exphazard}{exponential hazard rate for the loss to follow-up distribution.}

\item{loss_milestone}{a tuple c(milestone, probability) that uniquely defines the
exponential loss to follow-up distribution, e.g. c(12, 0.99) corresponds to the
exponential distribution with 1\% loss to follow-up at 12 months.}

\item{follow_time}{Follow-up duration. Either \code{follow_time} or
\code{total_time} (below) should be specified.}

\item{total_time}{Total study duration. Either \code{follow_time} (above) or
\code{total_time} should be specified.}
}
\value{
a list containing assumptions of size, accrual, censoring, survival, and
  follow-up for a single arm.
}
\description{
Create an object of class 'lachin' by specifying the trial parameters for
a single arm, including the sample size, accrual distribution,
survival distribution, loss to follow-up distribution, and study duration.
'Lachin' objects are also 'arm' objects, but with accrual limited
to the uniform and truncated exponential distributions, and survival and
loss to follow-up limited to the exponential distribution. 'Lachin' objects
have the advantage that expectations for certain counting processes have
closed form equations and can therefore be calculated more efficiently
(Lachin and Foulkes, 1986).
}
\examples{
# 3 arms with similar survival and loss to follow-up
create_arm_lachin(size=120, accr_time=6,
  surv_median=14,
  loss_median=140,
  follow_time=12)
create_arm_lachin(size=120, accr_time=6,
  surv_exphazard=0.05,
  loss_exphazard=0.005,
  follow_time=12)
create_arm_lachin(size=120, accr_time=6,
  accr_dist="truncexp",
  accr_param=0.1,
  surv_milestone=c(14, 0.5),
  loss_milestone=c(140, 0.5),
  total_time=18)
}
\references{
Lachin, J. M. and Foulkes, M. A. (1986) Evaluation of sample size and power for analyses of
  survival with allowance for nonuniform patient entry, losses to follow-up,
  noncompliance, and stratification. \emph{Biometrics}, \strong{42}, 507-519.
}
\seealso{
\code{\link{create_arm}} for creating an object of class 'arm'.
}
