% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R
\name{nse.boot}
\alias{nse.boot}
\title{Bootstrap estimator}
\usage{
nse.boot(x, nb, type = c("stationary", "circular"), b = NULL, lag.prewhite = 0)
}
\arguments{
\item{x}{A numeric vector.}

\item{nb}{The number of bootstrap replications.}

\item{type}{The bootstrap scheme used, among \code{"stationary"} and \code{"circular"}. Default is \code{type = "stationary"}.}

\item{b}{The block length for the block bootstrap. If \code{NULL} automatic block length selection. Default is \code{b = NULL}.}

\item{lag.prewhite}{Prewhite the series before analysis (integer or \code{NULL}). When \code{lag.prewhite = NULL} this performs automatic lag selection. Default is \code{lag.prewhite = 0} that is no prewhitening.}
}
\value{
The NSE estimator.
}
\description{
Function which calculates the numerical standard error with bootstrap estimator.
}
\note{
\code{nse.boot} uses \code{\link[np]{b.star}} of the \code{\link{np}} package
for the optimal block length selection.
}
\examples{
\dontrun{
n    = 1000
ar   = 0.9
mean = 1
sd   = 1

set.seed(1234)
x = c(arima.sim(n = n, list(ar = ar), sd = sd) + mean)

set.seed(1234)
nse.boot(x = x, nb = 1000, type = "stationary", b = NULL, lag.prewhite = 0)
nse.boot(x = x, nb = 1000, type = "circular", b = NULL, lag.prewhite = NULL)
nse.boot(x = x, nb = 1000, type = "circular", b = 10, lag.prewhite = NULL)
}
}
\references{
Politis, D.N., Romano, and J.P. (1992).
A circular block-resampling procedure for stationary data.
In \emph{Exploring the limits of bootstrap}, John Wiley & Sons,  263-270.

Politis, D.N., Romano, and J.P. (1994).
The stationary bootstrap.
\emph{Journal of the American Statistical Association} \bold{89}(428),  1303-1313.

Politis, D.N., White, H. (2004).
Automatic block-length selection for the dependent bootstrap.
\emph{Econometric Reviews} \bold{23}(1),  53-70.
}
\author{
David Ardia and Keven Bluteau
}
