% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R, R/conversions.R, R/force.R
\name{dots}
\alias{dots}
\alias{dots_}
\alias{exprs}
\alias{exprs.dots}
\alias{exprs<-}
\alias{exprs<-.dots}
\alias{envs}
\alias{envs.dots}
\alias{envs<-}
\alias{[.dots}
\alias{[<-.dots}
\alias{c.dots}
\alias{c.quotation}
\alias{as.data.frame.dots}
\alias{forced_dots}
\alias{forced_dots_}
\title{Dots objects: lists of quotations.}
\usage{
dots(...)

dots_(exprs, envs)

exprs(d)

\method{exprs}{dots}(d)

exprs(d) <- value

\method{exprs}{dots}(d) <- value

envs(d)

\method{envs}{dots}(d)

envs(d) <- value

\method{[}{dots}(x, ..., drop = FALSE)

\method{[}{dots}(x, ...) <- value

\method{c}{dots}(...)

\method{c}{quotation}(...)

\method{as.data.frame}{dots}(x, row.names = NULL, ...)

forced_dots(...)

forced_dots_(values)
}
\arguments{
\item{...}{Any number of arguments.}

\item{exprs}{An expression or list of expressions.}

\item{envs}{An environment or list of environments.}

\item{d}{A \link{dots} object.}

\item{value}{A replacement value or list of values.}

\item{x}{A \code{\link{dots}} object.}

\item{drop}{See \link{Extract}.}

\item{row.names}{If not given, uses \code{make.unique(x$name)}}

\item{values}{A list; each element will be used as data.}
}
\value{
\code{dots(...)} constructs a list with class 'dots', each
element of which is a \link{quotation}.

\code{dots_(exprs, envs)} constructs a dots object given lists
of expressions and environments. (To construct a dots object from
quotation objects, use \code{\link[=c]{c()}}.)

\code{exprs(d)} extracts a list of expressions from a dots object.

The mutator \code{exprs(d) <- value} returns a new dots object
with the new expressions.

\code{envs(d)} extracts a list of environments from a dots
object.

\code{envs(d)} returns a named list of environments.

\code{envs(d) <- value} returns an updated dots object with the
environments replaced with the new value(s).

\code{as.data.frame.dots} returns a data frame.
}
\description{
\code{d <- dots(a = one, b = two)} captures each of its arguments,
unevaluated, in a dots object (a named list of \link{quotation}s).

\code{as.data.frame.dots} transforms the contents of a \link{dots} object
into a data frame with one row per \link{quotation}, with columns:
\itemize{
\item \code{name}: a character,
\item \code{expr}: an expression,
\item \code{env}: an \link{environment} object or NULL if \link{forced},
\item \code{value}: NULL or a value if forced.
}

\code{forced_dots(...)} forces its arguments and constructs a \code{dots} object with
\link{forced} quotations.

\code{forced_dots_(values)} creates a dots object from a list of values
}
\details{
Objects of class "dots" mirror R's special variable \code{...}.
Unlike \code{...}, a \code{dots} is:
\itemize{
\item immutable (evaluating does not change it),
\item first-class (you can give it any name, not just \code{...}),
\item data (The R interpreter treates it as literal data rather
than triggering argument splicing).
}

\code{d <- dots(...)} is used to capture the contents of \code{...} without
triggering evaluation. This improves on
\code{as.list(substitute(...()))} by capturing the environment of each
argument along with their expressions. (You can also use
\code{\link[=get_dots]{get_dots()}}.)
}
\note{
The columns have a class \code{"oneline"} for better printing.
}
\examples{

named.list <- function(...) {
 # Collect only named arguments, ignoring unnamed arguments.
 d <- dots(...)
 do(list, d[names(d) != ""])
}

named.list(a=1, b=2*2, stop("this is not evaluated"))
}
