% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_diff.r
\name{opt_bin_diff}
\alias{opt_bin_diff}
\title{Finds the number of bins in x and y direction which gives the maximum binned distance.}
\usage{
opt_bin_diff(
  lineup.dat,
  var,
  xlow,
  xhigh,
  ylow,
  yhigh,
  pos,
  plot = FALSE,
  m = 20
)
}
\arguments{
\item{lineup.dat}{lineup data to get the lineup}

\item{var}{a list of names of the variables to be used to calculate the difference}

\item{xlow}{the lowest value of number of bins on the x-direction}

\item{xhigh}{the highest value of number of bins on the x-direction}

\item{ylow}{the lowest value of number of bins on the y-direction}

\item{yhigh}{the highest value of number of bins on the y-direction}

\item{pos}{position of the true plot in the lineup}

\item{plot}{LOGICAL; if true, returns a tile plot for the combinations
of number of bins with the differences as weights}

\item{m}{number of plots in the lineup, by default m = 20}
}
\value{
a dataframe with the number of bins and differences
the maximum mean distance of the null plots
}
\description{
This function finds the optimal number of bins in both x and y direction which should
be used to calculate the binned distance. The binned distance is calculated for each
combination of provided choices of number of bins in x and y direction and finds the
difference using \code{calc_diff} for each combination. The combination for which the
difference is maximum should be used.
}
\examples{
if(require('dplyr')){
opt_bin_diff(lineup(null_permute('mpg'), mtcars, pos = 1), var = c('mpg', 'wt'),
2, 5, 4, 8, pos = 1, plot = TRUE, m = 8)
}
}
