% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_12_hour.R
\name{f_12_hour}
\alias{f_12_hour}
\alias{f_12_hour.default}
\alias{f_12_hour.integer}
\alias{f_12_hour.numeric}
\alias{f_12_hour.hms}
\alias{ff_12_hour}
\title{Format 12 Hour Times}
\usage{
f_12_hour(x = Sys.time(), format = "\%I:\%M \%p", pad.char = "", ...)

\method{f_12_hour}{default}(x, format = "\%I:\%M \%p", pad.char = "",
  ...)

\method{f_12_hour}{integer}(x, format = "\%I:\%M \%p", pad.char = "",
  ...)

\method{f_12_hour}{numeric}(x, format = "\%I:\%M \%p", pad.char = "",
  ...)

\method{f_12_hour}{hms}(x, format = "\%I:\%M \%p", pad.char = "", ...)

ff_12_hour(format = "\%I:\%M \%p", pad.char = "", ...)
}
\arguments{
\item{x}{A vector of coercible times.}

\item{format}{A character string specifying the time output format.}

\item{pad.char}{A character to use for leading padding if lengths of output
are unequal.}

\item{\ldots}{Other arguments passed to \code{\link[base]{as.POSIXct}}.}
}
\value{
Returns a string of publication ready 12 hour time stamps.
}
\description{
Format times to the typical 12 hour '%I:%M %p' in-text format.
}
\examples{
f_12_hour(Sys.time())
f_12_hour(Sys.time(), pad.char ='0')
f_12_hour(Sys.time(), pad.char =' ')
f_12_hour(Sys.time(), '\%I:\%M:\%S \%p')
f_12_hour(c(NA, 0:24), '\%I \%p')
set.seed(10)
times <- as.POSIXct(sample(seq_len(1e4), 12), origin = '1970-01-01')
paste(f_12_hour(range(times)), collapse = ' to ')
\dontrun{
library(tidyverse)

set.seed(10)
data_frame(
    time = as.POSIXct(sample(seq_len(1e4), 12), origin = '1970-01-01'),
    val = sample(1:20, length(time), TRUE)
) \%>\%
    mutate(prop = val/sum(val)) \%>\%
    ggplot(aes(time, prop)) +
        geom_line() +
        scale_x_time(labels = ff_12_hour(format = '\%I \%p')) +
        scale_y_continuous(labels = ff_prop2percent(digits = 0))
}
}
