% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_data.R
\name{f_data}
\alias{f_data}
\alias{ff_data}
\alias{f_byte}
\alias{ff_byte}
\alias{f_kilo}
\alias{ff_kilo}
\alias{f_mega}
\alias{ff_mega}
\alias{f_giga}
\alias{ff_giga}
\alias{f_tera}
\alias{ff_tera}
\alias{f_peta}
\alias{ff_peta}
\alias{f_exa}
\alias{ff_exa}
\alias{f_zetta}
\alias{ff_zetta}
\alias{f_yotta}
\alias{ff_yotta}
\title{Convert and Abbreviate Units of Data.}
\usage{
f_data(x, binary = FALSE, digits = 0, pad.char = " ",
  less.than.replace = FALSE, sep = "", mix.units = FALSE,
  from = "B", ...)

ff_data(...)

f_byte(x, to = "B", binary = FALSE, digits = 0,
  suffix = f_data_abbreviation(to), pad.char = " ",
  less.than.replace = FALSE, from = "B", sep = "", ...)

ff_byte(...)

f_kilo(x, to = "KB", binary = FALSE, digits = 0,
  suffix = f_data_abbreviation(to), pad.char = " ",
  less.than.replace = FALSE, from = "B", sep = "", ...)

ff_kilo(...)

f_mega(x, to = "MB", binary = FALSE, digits = 0,
  suffix = f_data_abbreviation(to), pad.char = " ",
  less.than.replace = FALSE, from = "B", sep = "", ...)

ff_mega(...)

f_giga(x, to = "GB", binary = FALSE, digits = 0,
  suffix = f_data_abbreviation(to), pad.char = " ",
  less.than.replace = FALSE, from = "B", sep = "", ...)

ff_giga(...)

f_tera(x, to = "TB", binary = FALSE, digits = 0,
  suffix = f_data_abbreviation(to), pad.char = " ",
  less.than.replace = FALSE, from = "B", sep = "", ...)

ff_tera(...)

f_peta(x, to = "PB", binary = FALSE, digits = 0,
  suffix = f_data_abbreviation(to), pad.char = " ",
  less.than.replace = FALSE, from = "B", sep = "", ...)

ff_peta(...)

f_exa(x, to = "EB", binary = FALSE, digits = 0,
  suffix = f_data_abbreviation(to), pad.char = " ",
  less.than.replace = FALSE, from = "B", sep = "", ...)

ff_exa(...)

f_zetta(x, to = "ZB", binary = FALSE, digits = 0,
  suffix = f_data_abbreviation(to), pad.char = " ",
  less.than.replace = FALSE, from = "B", sep = "", ...)

ff_zetta(...)

f_yotta(x, to = "YB", binary = FALSE, digits = 0,
  suffix = f_data_abbreviation(to), pad.char = " ",
  less.than.replace = FALSE, from = "B", sep = "", ...)

ff_yotta(...)
}
\arguments{
\item{x}{A vector of data units.}

\item{binary}{logical.  If \code{TRUE} the result uses binary conversion,
otherwise decimal conversion is used.
See \url{https://en.wikipedia.org/wiki/Binary_prefix} for additional
information on standards.}

\item{digits}{The number of digits to round to. .}

\item{pad.char}{A character to use for leading padding if lengths of output
are unequal.  Use \code{NA} to forgo padding.}

\item{less.than.replace}{logical.  If \code{TRUE} values lower than lowest
place value will be replaced with a less than sign followed by the
\code{integer} representation of the place value.  For example, if \code{"0GB"}
then replacement will be \code{"<1GB"}.}

\item{sep}{The separator to use between the number and data unit abbreviation.}

\item{mix.units}{logical.  If \code{TRUE} then units can be mixed.
Typically, this is not a good idea for the sake of comparison.  It is most
useful when there is a total row which is a sum of the column and this value's
unit exceeds the unit of the rest of the column.}

\item{from}{The starting unit.  Typically, this is assumed to be 'Bytes' ('B').
Must be one of c("Bit", "Byte", "Kilobyte", "Megabyte", "Gigabyte", "Terabyte",
"Petabyte", "Exabyte", "Zettabyte", "Yottabyte") or c("b", "B", "KB", "MB",
"GB", "TB", "PB", "EB", "ZB", "YB").  These are case sensitive.}

\item{to}{The units to convert to.  See the \code{from} parameter for accepted
units.}

\item{suffix}{A suffix to use for the units at the end of the numeric string.
Typically the user will not interact with this argument.  Meant for internal
modularity of functions.}

\item{\ldots}{ignored.}
}
\value{
Returns a converted and abbreviated vector of units of data.
}
\description{
Convert numeric data to shorter form with unit abbreviations attached.  For
example, move from  10,000,000,000 (Bytes) to 10GB (Gigabytes) instead.

\code{f_byte} - Force the abbreviation to bytes
unit (B).

\code{f_kilo} - Force the abbreviation to kilobytes
unit (KB).

\code{f_mega} - Force the abbreviation to megabytes
unit (MB).

\code{f_giga} - Force the abbreviation to gigabytes
unit (GB).

\code{f_tera} - Force the abbreviation to terabytes
unit (TB).

\code{f_peta} - Force the abbreviation to petabytes
unit (PB).

\code{f_exa} - Force the abbreviation to exabytes
unit (EB).

\code{f_zetta} - Force the abbreviation to zettabytes
unit (ZB).

\code{f_yotta} - Force the abbreviation to yottabytes
unit (YB).
}
\examples{
\dontrun{
x <- c(NA, '3', '-', -233456789, -2334567890, 10^(0:10))
f_data(x)
f_data(x, pad.char = NA)
f_data(x, mix.units = TRUE)
f_data(x, mix.units = TRUE, binary = TRUE)
f_data(x, mix.units = TRUE, binary = TRUE, digits = 2)
f_byte(100000000, from = 'GB', binary = TRUE)
f_giga(10000000000)
f_giga(10000000000, suffix = 'Gb')

library(tidyverse)
set.seed(15)
dat <- data_frame(
    bytes = round(rnorm(7, 1e7, 7.95e6), 0),
    days = constant_weekdays \%>\%
        as_factor()
)

dat \%>\%
    mutate(
        data = f_data(bytes, less.than.replace = TRUE),
        weekday = f_weekday(days, distinct = TRUE) \%>\%
            as_factor()
    )

dat \%>\%
    mutate(days = days \%>\% as_factor()) \%>\%
    ggplot(aes(days, bytes, group = 1)) +
        geom_line() +
        geom_point() +
        scale_y_continuous(labels = f_data) +
        scale_x_discrete(labels = ff_weekday(distinct = TRUE))
}
}
