% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{get_nutrientamount}
\alias{get_nutrientamount}
\title{get_nutrientamount}
\usage{
get_nutrientamount(apiKey = NULL, foodCode = NULL, lang = "en")
}
\arguments{
\item{apiKey}{Key to access the API. Can be retrieved from
\url{https://hc-sc.api.canada.ca/en/detail?api=cnf#!/Nutrient/get_nutrientamount}.
If none is provided, the system environment variables will be checked.}

\item{foodCode}{The code indicating the food you want to search for. If null,
all foods and their corresponding nutrient amount are returned.}

\item{lang}{The language to return results in, can be either 'en' or 'fr'.}
}
\value{
A tibble containing the foodCode, nutrient_value, number_observation,
nutrientNameId, nutrient_web_name, nutrient_source_id
}
\description{
Makes a query to the Canadian Nutrient File nutrientamount endpoint. This endpoint returns
a list of nutrient id's and details about their corresponding nutrient amounts,
standard error of observation of nutrient amount and their names. For instance,
for nutrient id 5,  the name of the nutrient measured is caffeine and its nutrient value is 0.
}
\examples{
\dontrun{
get_nutrientamount()
get_nutrientamount(foodCode = 4)
get_nutrientamount(foodCode = 4, lang = "fr")
}
}
