% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_school_discharge.R
\name{nyc_school_discharge}
\alias{nyc_school_discharge}
\title{NYC School Discharge Reporting (Local Law 42)}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/a2gn-nyzs>
}
\usage{
nyc_school_discharge(limit = 10000, filters = list(), timeout_sec = 30)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing School Discharge Reporting (Local Law 42) data.
}
\description{
Downloads School Discharge Reporting (Local Law 42) data from NYC Open Data.
}
\details{
This dataset reports student discharges from NYC public schools,
as required under Local Law 42. It includes counts and percentages of
students discharged by category, such as transfer, dropout, or other reasons.
Data are aggregated by school and year, supporting analysis of
student outcomes across the city.
}
\examples{
# Examples that hit the live NYC Open Data API are wrapped so CRAN checks
# do not fail when the network is unavailable or slow.
\donttest{
if (curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_school_discharge(limit = 2)
  small_sample

  nyc_school_discharge(filters = list(school_level = "High School"))
}
}
}
