% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMatchAlignments.R
\name{getMatchAlignments}
\alias{getMatchAlignments}
\title{Gets temporal alignments of matches on a given layer.}
\usage{
getMatchAlignments(
  labbcat.url,
  matchIds,
  layerIds,
  targetOffset = 0,
  annotationsPerLayer = 1,
  anchor.confidence.min = 50
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{matchIds}{A vector of annotation IDs, e.g. the MatchId column, or the URL column,
of a results set.}

\item{layerIds}{A vector of layer IDs.}

\item{targetOffset}{The distance from the original target of the match, e.g.
\itemize{
 \item{\emph{0} -- find annotations of the match target itself},
 \item{\emph{1} -- find annotations of the token immediately \emph{after} match target}
 \item{\emph{-1} -- find annotations of the token immediately \emph{before} match target}
}}

\item{annotationsPerLayer}{The number of annotations on the given layer to
retrieve. In most cases, there's only one annotation available. However, tokens
may, for example, be annotated with `all possible phonemic transcriptions', in which
case using a value of greater than 1 for this parameter provides other phonemic
transcriptions, for tokens that have more than one.}

\item{anchor.confidence.min}{The minimum confidence for alignments, e.g.
\itemize{
 \item{\emph{0} -- return all alignments, regardless of confidence;}
 \item{\emph{50} -- return only alignments that have been at least automatically aligned;}
 \item{\emph{100} -- return only manually-set alignments.}
}}
}
\value{
A data frame with label, start time, and end time, for each layer.
}
\description{
Gets labels and start/end offsets of annotations on a given layer, identified by given
match IDs.
}
\details{
You can specify a threshold for confidence in the alignment, which is a value from 0
(not aligned) to 100 (manually aligned). The default is 50 (automatically aligned), so
only alignments that have been at least automatically aligned are specified. For cases
where there's a token but its alignment confidence falls below the threshold, a label
is returned, but the start/end times are NA.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Perform a search
results <- getMatches(labbcat.url, list(segments="I"))

## Get the segment following the token, with alignment if it's been manually aligned
following.segment <- getMatchAlignments(labbcat.url, results$MatchId, "segments",
    targetOffset=1, anchor.confidence.min=100)
}

}
\seealso{
\code{\link{getMatches}}
\code{\link{getMatchLabels}}
}
\keyword{annotation}
\keyword{label}
\keyword{layer}
