% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outbreaker_data.R
\name{outbreaker_data}
\alias{outbreaker_data}
\title{Process input data for outbreaker}
\usage{
outbreaker_data(..., data = list(...))
}
\arguments{
\item{...}{a list of data items to be processed (see description)}

\item{data}{optionally, an existing list of data item as returned by \code{outbreaker_data}.}
}
\value{
A named list containing the value of each elements listed in the 'Details' section. This list describes the data that will be used by the function \code{outbreaker()}.
}
\description{
This function performs various checks on input data given to outbreaker.  It
takes a list of named items as input, performs various checks, set defaults
where arguments are missing, and return a correct list of data input. If no
input is given, it returns the default settings.
}
\details{
Acceptable arguments for ... are:
\describe{
\item{dates}{a vector indicating the collection dates, provided either as
integer numbers or in a usual date format such as \code{Date} or
\code{POSIXct} format. By convention, zero will indicate the oldest date. 
Cases must be ordering by ascending onset date.}

\item{age_group}{a vector indicating the age group of the cases, provided as
integer numbers. The value of age group corresponds to the position of this age
group in a_dens.}

\item{region}{a vector indicating the region of the cases, provided as
integer numbers or characters. If numeric, the value of the region corresponds 
to the position of the region in the distance matrix and the population vector.
Otherwise, the value corresponds to the region and will be matched to the distance
matrix and the population vector.}

\item{w_dens}{a vector of numeric values indicating the generation time
distribution, reflecting the infectious potential of a case t = 1, 2, ...
time steps after infection. By convention, it is assumed that
newly infected patients cannot see new infections on the same time step. If not
standardized, this distribution is rescaled to sum to 1.}

\item{f_dens}{similar to \code{w_dens}, except that this is the distribution
of the incubation period, i_e. time interval between the reported onset date
and the infection date.}

\item{a_dens}{a matrix of numeric values indicating the contact between age 
groups, reflecting on the infectious potential of a case for a given age group.}

\item{genotype}{a character vector showing the genotype in each case.}

\item{is_cluster}{an integer vector indicating which group of cases each case
 belongs to.}
 
\item{s_dens}{a matrix of numeric values indicating the initial value of 
the connectivity between region. Only needed if a and b are fixed in the model, 
otherwise NULL.}

\item{population}{a double vector indicating the population in every region 
considered in the study.}

\item{distance}{a double matrix indicating the distance between each region.}

\item{import}{a logical vector indicating whether each case is an import (TRUE)
 or not (FALSE).}

}
}
\examples{

data("toy_outbreak_short")
dt_cases <- toy_outbreak_short$cases
dt_cases <- dt_cases[order(dt_cases$Date), ]
dt_regions <- toy_outbreak_short$dt_regions
all_dist <- geosphere::distGeo(matrix(c(rep(dt_regions$long, nrow(dt_regions)), 
                                        rep(dt_regions$lat, nrow(dt_regions))), 
                                      ncol = 2), 
                               matrix(c(rep(dt_regions$long, each = nrow(dt_regions)), 
                                        rep(dt_regions$lat, each = nrow(dt_regions))),
                                      ncol = 2))

dist_mat <- matrix(all_dist/1000, nrow = nrow(dt_regions))
pop_vect <- dt_regions$population
names(pop_vect) <- rownames(dist_mat) <- colnames(dist_mat) <- dt_regions$region
data <- outbreaker_data(dates = dt_cases$Date, age_group = dt_cases$age_group,
                        region = dt_cases$Cens_tract, population = pop_vect, 
                        distance = dist_mat)

}
\author{
Initial version by Thibaut Jombart, rewritten by Alexis Robert (\email{alexis.robert@lshtm.ac.uk})
}
