% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lobo.R
\docType{methods}
\name{plot,lobo-method}
\alias{plot,lobo-method}
\title{Plot LOBO data}
\usage{
\S4method{plot}{lobo}(x, which = c(1, 2, 3), adorn = NULL,
  mgp = getOption("oceMgp"), mar = c(mgp[2] + 1, mgp[1] + 1, 1, mgp[1] +
  1.25), debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{A \code{lobo} object, e.g. as read by \code{\link{read.lobo}}.}

\item{which}{A vector of numbers or character strings, indicating the
quantities to plot.  These are stacked in a single column.  The possible
values for \code{which} are as follows: \code{1} or \code{"temperature"} for
a time series of temperature; \code{2} or \code{"salinity"} for salinity;
\code{3} or \code{"TS"} for a TS diagram; \code{4} or \code{"u"} for a
timeseries of the u component of velocity; \code{5} or \code{"v"} for a
timeseries of the v component of velocity; \code{6} or \code{"nitrate"} for
a timeseries of nitrate concentration; \code{7} or \code{"fluorescence"} for
a timeseries of fluorescence value.}

\item{adorn}{(\strong{Defunct})
An \code{\link{expression}} or vector of expressions that contain
R code that is to be executed immediately after each panel of the plot.
If the number of expressions matches the number of panels, then the 
expressions are used for the corresponding panels; otherwise, the
expression list is extended to match the number of panels (i.e.
to obtain \code{length(which)} elements). Note that \code{adorn}
is a dangerous argument, because if the expressions contained
therein set up local storage, there is a chance of entirely
disrupting the plotting. \strong{For this reason, \code{adorn} was
marked as defunct in June 2016, and will be removed entirely 
after the July CRAN release.} Users with existing code that uses
\code{adorn} should simply plot the panels individually, and
use conventional R functions, e.g. \code{\link{lines}} etc.,
after each panel, to achieve the desired effect.  (See
\code{\link{oce-defunct}} for notes on other deprecated or
defunct \code{oce} features.)}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and also
for \code{par(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{value to be used with \code{\link{par}("mar")}.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed.}

\item{\dots}{optional arguments passed to plotting functions.}
}
\description{
Plot a summary diagram for lobo data.
}
\author{
Dan Kelley
}
\seealso{
Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}

Other things related to \code{lobo} data: \code{\link{[[,lobo-method}},
  \code{\link{[[<-,lobo-method}}, \code{\link{as.lobo}},
  \code{\link{lobo-class}}, \code{\link{lobo}},
  \code{\link{subset,lobo-method}},
  \code{\link{summary,lobo-method}}
}

