% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topo.R
\docType{methods}
\name{plot,topo-method}
\alias{plot,topo-method}
\title{Plot a Topo Object}
\usage{
\S4method{plot}{topo}(x, xlab = "", ylab = "", asp, clongitude, clatitude,
  span, expand = 1.5, water.z, col.water, lty.water, lwd.water, land.z,
  col.land, lty.land, lwd.land, geographical = FALSE, location = "topright",
  mgp = getOption("oceMgp"), mar = c(mgp[1] + 1, mgp[1] + 1, 1, 1),
  debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{A \code{topo} object, i.e. inheriting from \code{\link{topo-class}}.}

\item{xlab, ylab}{Character strings giving a label for the x and y axes.}

\item{asp}{Aspect ratio for plot.  The default is for \code{plot.coastline} to
set the aspect ratio to give natural latitude-longitude scaling somewhere near
the centre latitude on the plot. Often, it makes sense to set \code{asp}
yourself, e.g. to get correct shapes at 45N, use \code{asp=1/cos(45*pi/180)}.
Note that the land mass is not symmetric about the equator, so to get good
world views you should set \code{asp=1} or set \code{ylim} to be symmetric
about zero.  Any given value of \code{asp} is ignored, if \code{clongitude} and
\code{clatitude} are given.}

\item{clongitude}{Optional center longitude of map, in degrees east; see
\code{clatitude}.}

\item{clatitude}{Optional center latitude of map, in degrees north.  If this
and \code{clongitude} are provided, then any provided value of \code{asp} is
ignored, and instead the plot aspect ratio is computed based on the center
latitude.  Also, if \code{clongitude} and \code{clatitude} are provided, then
\code{span} must be, also.}

\item{span}{Optional suggested span of plot, in kilometers (must be supplied,
if \code{clongitude} and \code{clatitude} are supplied).}

\item{expand}{Numerical factor for the expansion of plot limits, showing area
outside the plot, e.g. if showing a ship track as a coastline, and then an
actual coastline to show the ocean boundary.  The value of \code{expand} is
ignored if either \code{xlim} or \code{ylim} is given.}

\item{water.z}{Depths at which to plot water contours.  If not provided, these
are inferred from the data.}

\item{col.water}{Colours corresponding to \code{water.z} values.  If not
provided, these will be \code{"fill"} colours from
\code{\link{oce.colorsGebco}}.}

\item{lty.water}{Line type(s) for water contours.}

\item{lwd.water}{Line width(s) for water contours.}

\item{land.z}{Depths at which to plot land contours.  If not provided, these
are inferred from the data.  If set to \code{NULL}, no land contours will be
plotted.}

\item{col.land}{Colours corresponding to \code{land.z} values.  If not
provided, these will be \code{"fill"} colours from
\code{\link{oce.colorsGebco}}.}

\item{lty.land}{Line type(s) for land contours.}

\item{lwd.land}{Line width(s) for land contours.}

\item{geographical}{Logical, indicating whether to plot latitudes and
longitudes without minus signs.}

\item{location}{Location for a legend (or \code{"none"}, for no legend).}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and also for
\code{par(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{Four-element numericl vector to be used with
\code{\link{par}("mar")}.}

\item{debug}{Numerical value, with positive values indicating higher levels of
debugging.}

\item{...}{Additional arguments passed on to plotting functions.}
}
\description{
This plots contours of topographic elevation.  The plot aspect ratio is set
based on the middle latitude in the plot.  The line properties, such as
\code{land.lwd}, may either be a single item, or a vector; in the latter case,
the length must match the length of the corresponding properties, e.g.
\code{land.z}.
}
\examples{
library(oce)
data(topoWorld)
plot(topoWorld, clongitude=-60, clatitude=45, span=10000)

}
\seealso{
Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,ladp-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}

Other things related to \code{topo} data: \code{\link{[[,topo-method}},
  \code{\link{[[<-,topo-method}}, \code{\link{as.topo}},
  \code{\link{download.topo}}, \code{\link{read.topo}},
  \code{\link{subset,topo-method}},
  \code{\link{summary,topo-method}},
  \code{\link{topo-class}}, \code{\link{topoInterpolate}},
  \code{\link{topoWorld}}
}
\author{
Dan Kelley
}
