% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\docType{methods}
\name{summary,section-method}
\alias{summary,section-method}
\title{Summarize a Section Object}
\usage{
\S4method{summary}{section}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"section"}, usually, a result of a call
to \code{\link{read.section}}, \code{\link{read.oce}}, or
\code{\link{as.section}}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
\code{NULL}
}
\description{
Pertinent summary information is presented, including station locations,
distance along track, etc.
}
\examples{
library(oce)
data(section)
summary(section)

}
\seealso{
Other things related to \code{section} data: \code{\link{[[,section-method}},
  \code{\link{[[<-,section-method}},
  \code{\link{as.section}},
  \code{\link{handleFlags,section-method}},
  \code{\link{plot,section-method}},
  \code{\link{read.section}}, \code{\link{section-class}},
  \code{\link{sectionAddStation}},
  \code{\link{sectionGrid}}, \code{\link{sectionSmooth}},
  \code{\link{sectionSort}}, \code{\link{section}},
  \code{\link{subset,section-method}}
}
\author{
Dan Kelley
}
