% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swTFreeze}
\alias{swTFreeze}
\title{Seawater freezing temperature}
\usage{
swTFreeze(salinity, pressure = 0, longitude = NULL, latitude = NULL,
  saturation_fraction = 1, eos = getOption("oceEOS", default = "gsw"))
}
\arguments{
\item{salinity}{either salinity [PSU] or a \code{ctd} object from which
salinity will be inferred.}

\item{pressure}{seawater pressure [dbar]}

\item{longitude}{longitude of observation (only used if \code{eos="gsw"};
see \sQuote{Details}).}

\item{latitude}{latitude of observation (only used if \code{eos="gsw"}; see
\sQuote{Details}).}

\item{saturation_fraction}{saturation fraction of dissolved air in seawater
(used only if \code{eos="gsw"}).}

\item{eos}{equation of state, either \code{"unesco"} [1,2] or \code{"gsw"}
[3,4].}
}
\value{
Temperature [\eqn{^\circ}{deg}C], defined on the ITS-90 scale.
}
\description{
Compute freezing temperature of seawater.
}
\details{
In the first form, the argument is a \code{ctd} object, from which the
salinity and pressure values are extracted and used to for the calculation.
}
\examples{
swTFreeze(salinity=40, pressure=500, eos="unesco") # -2.588567 degC

}
\references{
[1] Fofonoff, P. and R. C. Millard Jr, 1983. Algorithms for
computation of fundamental properties of seawater. \emph{Unesco Technical
Papers in Marine Science}, \bold{44}, 53 pp

[2] Gill, A.E., 1982. \emph{Atmosphere-ocean Dynamics}, Academic Press, New
York, 662 pp.

[3] IOC, SCOR, and IAPSO (2010). The international thermodynamic equation of
seawater-2010: Calculation and use of thermodynamic properties.  Technical
Report 56, Intergovernmental Oceanographic Commission, Manuals and Guide.

[4] McDougall, T.J. and P.M. Barker, 2011: Getting started with TEOS-10 and
the Gibbs Seawater (GSW) Oceanographic Toolbox, 28pp., SCOR/IAPSO WG127,
ISBN 978-0-646-55621-5.
}
\seealso{
Other functions that calculate seawater properties: \code{\link{T68fromT90}},
  \code{\link{T90fromT48}}, \code{\link{T90fromT68}},
  \code{\link{swAbsoluteSalinity}},
  \code{\link{swAlphaOverBeta}}, \code{\link{swAlpha}},
  \code{\link{swBeta}}, \code{\link{swCSTp}},
  \code{\link{swConservativeTemperature}},
  \code{\link{swDepth}}, \code{\link{swDynamicHeight}},
  \code{\link{swLapseRate}}, \code{\link{swN2}},
  \code{\link{swPressure}}, \code{\link{swRho}},
  \code{\link{swRrho}}, \code{\link{swSCTp}},
  \code{\link{swSTrho}}, \code{\link{swSigma0}},
  \code{\link{swSigma1}}, \code{\link{swSigma2}},
  \code{\link{swSigma3}}, \code{\link{swSigma4}},
  \code{\link{swSigmaTheta}}, \code{\link{swSigmaT}},
  \code{\link{swSigma}}, \code{\link{swSoundAbsorption}},
  \code{\link{swSoundSpeed}}, \code{\link{swSpecificHeat}},
  \code{\link{swSpice}}, \code{\link{swTSrho}},
  \code{\link{swThermalConductivity}},
  \code{\link{swTheta}}, \code{\link{swViscosity}},
  \code{\link{swZ}}
}
\author{
Dan Kelley
}
\concept{functions that calculate seawater properties}
