% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sealevel.R
\name{subset,sealevel-method}
\alias{subset,sealevel-method}
\title{Subset a Sealevel Object}
\usage{
\S4method{subset}{sealevel}(x, subset, ...)
}
\arguments{
\item{x}{a \linkS4class{sealevel} object.}

\item{subset}{a condition to be applied to the \code{data} portion of
\code{x}.}

\item{\dots}{ignored.}
}
\value{
A new \code{sealevel} object.
}
\description{
This function is somewhat analogous to \code{\link[=subset.data.frame]{subset.data.frame()}}, but
subsetting is only permitted by time.
}
\examples{
library(oce)
data(sealevel)
plot(sealevel)
plot(subset(sealevel, time < mean(range(sealevel[['time']]))))

}
\seealso{
Other things related to sealevel data: 
\code{\link{[[,sealevel-method}},
\code{\link{[[<-,sealevel-method}},
\code{\link{as.sealevel}()},
\code{\link{plot,sealevel-method}},
\code{\link{read.sealevel}()},
\code{\link{sealevel-class}},
\code{\link{sealevelTuktoyaktuk}},
\code{\link{sealevel}},
\code{\link{summary,sealevel-method}}

Other functions that subset oce objects: 
\code{\link{subset,adp-method}},
\code{\link{subset,adv-method}},
\code{\link{subset,amsr-method}},
\code{\link{subset,argo-method}},
\code{\link{subset,cm-method}},
\code{\link{subset,coastline-method}},
\code{\link{subset,ctd-method}},
\code{\link{subset,echosounder-method}},
\code{\link{subset,lobo-method}},
\code{\link{subset,met-method}},
\code{\link{subset,oce-method}},
\code{\link{subset,odf-method}},
\code{\link{subset,rsk-method}},
\code{\link{subset,section-method}},
\code{\link{subset,topo-method}},
\code{\link{subset,xbt-method}}
}
\author{
Dan Kelley
}
\concept{functions that subset oce objects}
\concept{things related to sealevel data}
