% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gps.R
\name{read.gps}
\alias{read.gps}
\title{Read a GPS File}
\usage{
read.gps(file, type = NULL, debug = getOption("oceDebug"), processingLog)
}
\arguments{
\item{file}{name of file containing gps data.}

\item{type}{type of file, which will be inferred from examination of the
data if not supplied.  In the present version, the only choice for
\code{type} is \code{"gpx"}.}

\item{debug}{set to TRUE to print information about the header, etc.}

\item{processingLog}{ignored.}
}
\value{
A \linkS4class{gps} object.
}
\description{
Reads GPX format files by simply finding all longitudes and latitudes; in
other words, information on separate tracks, or waypoints, etc., is lost.
}
\seealso{
Other things related to gps data: 
\code{\link{[[,gps-method}},
\code{\link{[[<-,gps-method}},
\code{\link{as.gps}()},
\code{\link{gps-class}},
\code{\link{plot,gps-method}},
\code{\link{summary,gps-method}}
}
\author{
Dan Kelley
}
\concept{things related to gps data}
