% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{summary.ocf}
\alias{summary.ocf}
\title{Summary Method for ocf Objects}
\usage{
\method{summary}{ocf}(object, ...)
}
\arguments{
\item{object}{An \code{\link{ocf}} object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Summarizes an \code{\link{ocf}} object.
}
\description{
Summarizes an \code{\link{ocf}} object.
}
\examples{
## Load data from orf package.
set.seed(1986)

library(orf)
data(odata)
odata <- odata[1:100, ] # Subset to reduce elapsed time.

y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

## Fit ocf.
forests <- ocf(y, X)

## Summary.
summary(forests)

}
\seealso{
\code{\link{ocf}}, \code{\link{marginal_effects}}
}
\author{
Riccardo Di Francesco
}
