\name{IDscluster2}
\alias{IDscluster2}
\title{
Memberships of Groups and Subgroups
}
\description{
Identify the memberships at every level of the topology in the bootstrapped clusters.
}
\usage{
IDscluster2(M2=M2)
}
\arguments{
  \item{M2}{ List object generated by glzcluster or glzcluster2
}
}

\value{
A list object with the memberships for the groups and subgroups all through the topology of the generalized cluster
}
\references{
Koleff, P., Gaston, K.J., Lennon, J. J. 2003. Measuring beta diversity for 
presence-absence data. Journal of Animal Ecology 71:367. 
https://doi.org/10.1046/j.1365-2656.2003.00710.x
}
\author{
Roger Guevara (roger.guevara@inecol.mx) & 
Ian MacGregor-Fors (ian.macgregor@helsinki.fi)
}
\examples{
data(dune)
M2 <- glzcluster(dune, n=5, prop=0.8, distance="bray", method="average")
GRPs <- IDscluster2(M2[[length(M2)]])
GRPs
}
