% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_to_sf_network}
\alias{od_to_sf_network}
\title{Convert OD data into lines with start and end points sampled on a network}
\usage{
od_to_sf_network(
  x,
  z,
  zd = NULL,
  silent = TRUE,
  package = "sf",
  crs = 4326,
  network = NULL
)
}
\arguments{
\item{x}{A data frame in which the first two columns are codes
representing points/zones of origin and destination}

\item{z}{Zones representing origins and destinations}

\item{zd}{Zones representing destinations}

\item{silent}{Hide messages? \code{FALSE} by default.}

\item{package}{Which package to use to create the sf object? \code{sfheaders} is the default.}

\item{crs}{The coordinate reference system of the output, if not known in \code{z}.
4326 by default.}

\item{network}{An sf object representing a transport network}
}
\description{
Convert OD data into lines with start and end points sampled on a network
}
\examples{
x = od_data_df
z = od_data_zones_min
network = od_data_network
(lines_to_points_on_network = od_to_sf_network(x, z, network = network))
(lines_to_points = od_to_sf(x, z))
}
