% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/odeintr.R
\docType{package}
\name{odeintr}
\alias{odeintr}
\alias{odeintr-package}
\title{Odeintr: Fast and Flexible Integration of Ordinary Differential Equations}
\description{
This package is a light-weight wrapper around the Boost ODEINT
library. It allows one to specify an ODE system in a few lines
of C++. This code is inserted into a template that is compiled.
The resulting Rcpp function will integrate the system.
}
\details{
You can also specify the model as an R function. Unlike
existing packages, you can also supply an observer function
that can return arbitrary data structures.

The main function is \code{compile_sys}, which takes a
snippet of C++ code calculating dervatives and compiles
an integrator function.

The function \code{integrate_sys} accepts an R function
defining the system and an observer function to record
the output in a data frame or list.
}
\author{
Timothy H. Keitt \cr \url{http://www.keittlab.org/} \cr \cr

Timothy H. Keitt \email{tkeitt@gmail.com} \cr
}
\references{
\url{http://github.com/thk686/odeintr}, \url{http://headmyshoulder.github.io/odeint-v2/}
}
\keyword{package}

